unit OpenPrgDialog;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ComCtrls, CommDlg, StdCtrls;

type
  TOpenPrgDialog = class(TOpenDialog)
  private
    FMemoPanel : TPanel;
    FMemo : TRichEdit;
    FTextFiles : String;
  protected
    procedure DoSelectionChange; override;
    procedure DoShow; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function Execute: Boolean; override;
  published
    property TextFiles : String read FTextFiles write FTextFiles;
  end;

procedure Register;

{$R PREVDLG.RES}

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TOpenPrgDialog]);
end;

constructor TOpenPrgDialog.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FMemoPanel := TPanel.Create(Self);
  with FMemoPanel do begin
    Name := 'MemoPanel';
    Caption := '';
    SetBounds(0, 0, 169, 200);
    BevelOuter := bvNone;
    BorderWidth := 6;
    TabOrder := 1;
  end;
  FMemo := TRichEdit.Create(Self);
  with FMemo do begin
    Name := 'Memo';
    Text := '';
    SetBounds(6, 6, 157, 188);
    ReadOnly := True;
    Align := alClient;
    Scrollbars := ssVertical;
    Parent := FMemoPanel;
  end;
  FTextFiles := '.PRG;.PAS;.TXT;.CPP;.H;.ASM;.INC;.RC;.DPR';
end;    //Create

destructor TOpenPrgDialog.Destroy;
begin
  FMemo.Free;
  FMemoPanel.Free;
  inherited Destroy;
end;    //Destroy

procedure TOpenPrgDialog.DoSelectionChange;
var
  FullName : String;
begin
  FullName := FileName;
  FMemo.Lines.Clear;
  if FileExists(FullName) and (GetFileAttributes(PChar(FileName)) <> $FFFFFFFF) and
    (Pos(UpperCase(ExtractFileExt(FullName)),FTextFiles) <> 0) then
  try
    FMemo.Lines.LoadFromFile(FullName);
  except
    ;
  end;
  inherited DoSelectionChange;
end;    //DoSelectionChange

procedure TOpenPrgDialog.DoShow;
var
  PreviewRect, StaticRect: TRect;
begin
  { Set preview area to entire dialog }
  GetClientRect(Handle, PreviewRect);
  StaticRect := GetStaticRect;
  { Move preview area to right of static area }
  StaticRect.Top := StaticRect.Bottom;
  StaticRect.Bottom := PreviewRect.Bottom-2;
  FMemoPanel.BoundsRect := StaticRect;
  FMemoPanel.ParentWindow := Handle;
  inherited DoShow;
end;    //DoShow

function TOpenPrgDialog.Execute : Boolean;
begin
  if NewStyleControls and not (ofOldStyleDialog in Options) then
    Template := 'PREVDLG' else
    Template := nil;
  Result := inherited Execute;
end;    //Execute
end.
